/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.command.Command;
import cz.insophy.inplan.command.JournalChangeListener;
import cz.insophy.inplan.command.UndoableCommand;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.EventListenerList2;
import cz.insophy.inplan.util.problems.Problem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Journal {
    private LinkedList<Command> journalStack = Lists.newLinkedList();
    private Map<Command, Long> dateAdded = Maps.newHashMap();
    private Map<Command, Boolean> selected = Maps.newHashMap();
    private Map<Command, Boolean> executed = Maps.newHashMap();
    private EventListenerList2 journalChangeListeners = new EventListenerList2();

    public void add(Command command) {
        this.journalStack.add(command);
        this.dateAdded.put(command, System.currentTimeMillis());
        this.fireJournalChanged();
    }

    public Command poll() {
        Command head = this.journalStack.pollLast();
        if (head != null) {
            this.dateAdded.remove(head);
            this.selected.remove(head);
            this.executed.remove(head);
            this.fireJournalChanged();
        }
        return head;
    }

    public List<Command> getCommands() {
        return Collections.unmodifiableList(Lists.reverse(this.journalStack));
    }

    public int getSize() {
        return this.journalStack.size();
    }

    public long getDateAdded(Command command) {
        if (!this.dateAdded.containsKey(command)) {
            return -9223372036854775708L;
        }
        return this.dateAdded.get(command);
    }

    public void setSelected(Command command, boolean sel) {
        this.selected.put(command, sel);
    }

    public Collection<Command> getSelectedCommands() {
        ArrayList<Command> res = Lists.newArrayList();
        for (Command cmd : this.journalStack) {
            if (!this.selected.containsKey(cmd) || !this.selected.get(cmd).booleanValue()) continue;
            res.add(cmd);
        }
        return res;
    }

    public boolean getSelected(Command command) {
        Boolean sel = this.selected.get(command);
        return sel != null ? sel : false;
    }

    public void setExecuted(Command command, boolean ex) {
        this.executed.put(command, ex);
    }

    public boolean getExecuted(Command command) {
        Boolean ex = this.executed.get(command);
        return ex != null ? ex : false;
    }

    public Command getCommand(int index) {
        return this.journalStack.get(index);
    }

    public boolean isLastUndoable() {
        return this.journalStack.peek() instanceof UndoableCommand;
    }

    public boolean isEmpty() {
        return this.journalStack.isEmpty();
    }

    public List<Problem> undo(Superplan superplan) {
        UndoableCommand command = (UndoableCommand)this.poll();
        this.executed.put(command, false);
        return command.unexecute(superplan);
    }

    public void clear() {
        this.journalStack.clear();
        this.dateAdded.clear();
        this.executed.clear();
        this.selected.clear();
        this.fireJournalChanged();
    }

    public void clearSelected() {
        for (Command cmd : this.getSelectedCommands()) {
            this.journalStack.remove(cmd);
            this.dateAdded.remove(cmd);
            this.executed.remove(cmd);
            this.selected.remove(cmd);
        }
        this.fireJournalChanged();
    }

    public void clearExecutedFlag() {
        for (Command cmd : this.journalStack) {
            this.executed.put(cmd, false);
        }
        this.fireJournalChanged();
    }

    public void addJournalChangeListener(JournalChangeListener listener) {
        this.journalChangeListeners.add(JournalChangeListener.class, listener);
    }

    public void removeJournalChangeListener(JournalChangeListener listener) {
        this.journalChangeListeners.remove(JournalChangeListener.class, listener);
    }

    public void fireJournalChanged() {
        for (JournalChangeListener l : this.journalChangeListeners.getListeners(JournalChangeListener.class)) {
            l.journalChanged();
        }
    }
}

